 aR  w / mP9      h	 oP      nSystem-wide$NOLIST

    NAME EMS

; This is EMS.Asm.  This file contains
; the routines that deal with the Intel/Lotus Expanded memory manager.

DGROUP GROUP DATA
CGROUP GROUP CODE

$INCLUDE (``OsIncs`CpConst~Inc~)


EXTRN  IntAllocate: FAR, CpFree: FAR, CpWait: FAR, CpSignal: FAR
EXTRN  CpGetMyRomSlot: FAR, IntCpSetActiveRomSlot: NEAR


PUBLIC InitEMS, EmsStartAddress
PUBLIC EmsAllocate, EmsFree, EmsFreeTasksMem, EmsGetMemStatus
PUBLIC EmsSaveContext, EMSSetActiveRam, EmsSwapTasksEmsRam, EmsSetProcessRam
PUBLIC CpSetActiveEmsSlot, CpGetMySlot

PUBLIC emsValid, ioPorts, numBoards, startAddress
PUBLIC sEmsList, emsListSema, integridEmsAlloc, emsContextSize


;           Constants

emsBase        EQU 40      ; Leave room for 40 rom entries

maxEmsEntries  EQU 64
maxEmsBufSize  EQU 128     ; 2 * maxEmsEntries
maxEmsBufBlks  EQU 8       ; maxEmsBufSize / 16

eNotSupport    EQU 35

invalidSlot    EQU 0FEH

ibmPc          EQU 2
ibmAt	      EQU 3

newVersFence   EQU 32H     ; Version 3.2 and above support fnc 15
vers40Fence    EQU 40H     ; Version 4.0 and above support unmapping

intMaskReg     EQU 21H     ; Mask register for interrupt controller
maskOffAllInts EQU 0FFH

EmsEntryType  STRUC
  emsBytes     DW ?
  emsBlocks    DW ?
  emsHandle    DW ?
  emsPid       DW ?
  emsID        DW ?
  emsUnused1   DW ?
  emsUnused2   DW ?
  emsUnused3   DW ?
  emsContext   DB dfltCntxtSize DUP (?)
EmsEntryType  ENDS


; data

DATA SEGMENT PUBLIC 'DATA'

	emsValid         DB 1  DUP (?)
	numBoards        DB 1  DUP (?)
	ioPorts          DW 16 DUP (?)
	startAddress     DW 1  DUP (?)

	sEmsList         DW 1  DUP (?)
	emsListSema      DW 1  DUP (?)
	emsSemaError     DW 1  DUP (?)
 
	emsContextSize   DW 1  DUP (?)
	sSavedContext    DW 1  DUP (?)
	sEmptyContext    DW 1  DUP (?)

	emsVersion       DB 1  DUP (?)
	integridEmsAlloc DB 1  DUP (?)


EXTRN curSlot: BYTE, romsExecute: BYTE

DATA ENDS


CODE SEGMENT BYTE PUBLIC 'CODE'
    ASSUME CS:CGROUP, DS:DGROUP
$EJECT

; WaitOnEmsSema: PROCEDURE CLEAN

WaitOnEmsSema PROC NEAR
	MOV	AX, emsListSema	; If emsSema does not exist
	OR	AX, AX	; yet, then
	JZ	WaitOnEmsSemaRet	; Return

	PUSH	AX	; semaphore ID

	MOV	AX, NULLWORD
	PUSH	AX	; wait forever

	PUSH	DS
	MOV	AX, OFFSET emsSemaError	; @dummyerror
	PUSH	AX

	CALL	CpWait

WaitOnEmsSemaRet:
	RET
WaitOnEmsSema ENDP


; SignalEmsSema: PROCEDURE CLEAN

; This routine must NOT change AX

SignalEmsSema PROC NEAR
	PUSH	AX

	MOV	AX, emsListSema	; If emsSema does not exist
	OR	AX, AX	; yet, then
	JZ	SignalEmsSemaRet	; Return

	PUSH	AX	; semaphore ID

	MOV	AX, signalNormal
	PUSH	AX	; normal signal

	PUSH	AX	; random note

	PUSH	DS
	MOV	AX, OFFSET emsSemaError	; @dummyerror
	PUSH	AX

	CALL	CpSignal

SignalEmsSemaRet:
	POP	AX
	RET
SignalEmsSema ENDP
$EJECT

; EmsSaveContext: PROCEDURE (pBuffer) CLEAN
;     DCL pBuffer PTR;
;
; This routine will save the context of EMS into pBuffer.  This
; buffer must be at least 16 bytes long.

; emsValid-ity must be checked by the caller and DS must point to DGROUP

pBuffer EQU DWORD PTR [BP+4]

EmsSaveContext PROC NEAR
	PUSH	BP
	MOV	BP, SP

	CMP	emsVersion, newVersFence
	JAE	EmsSaveContextNew

EmsSaveContextOld:
	LES	DI, pBuffer
	MOV	CL, numBoards
	XOR	CH, CH
	SHL	CX, 1
	SHL	CX, 1	; 4 IO ports per board
	MOV	SI, OFFSET DGROUP:IOPorts
	CLD

EmsSaveLoop:
	LODSW	; Get the IOPort
	MOV	DX, AX
	IN	AL, DX	; Get the map value
	STOSB	; Save it
	LOOP	EmsSaveLoop
	JMP	SHORT EmsSaveExit

EmsSaveContextNew:
	MOV	AX, 4E00H
	LES	DI, pBuffer
	INT	67H

EmsSaveExit:
	POP	BP
	RET	4
EmsSaveContext ENDP

PURGE pBuffer
$EJECT

; EmsSetActiveRam: PROCEDURE (pBuffer) CLEAN
;     DCL pBuffer    PTR
;
; This routine will set the ram in EMS that is represented by pBuffer.

; emsValid-ity must be checked by the caller and DS must point to DGROUP

pBuffer EQU DWORD PTR [BP+4]

EMSSetActiveRam PROC NEAR
	PUSH	BP
	MOV	BP, SP

	CMP	emsVersion, newVersFence
	JAE	EmsSetActiveNew

EmsSetActiveOld:
	LES	DI, pBuffer
	MOV	CL, numBoards
	XOR	CH, CH
	SHL	CX, 1
	SHL	CX, 1	; 4 IO ports per board
	MOV	SI, OFFSET DGROUP:IOPorts
	CLD

EmsSetLoop:
	LODSW	; Get the IOPort
	MOV	DX, AX
	MOV	AL, BYTE PTR ES:[DI]	; Get the map value
	OUT	DX, AL	; Write it out
	INC	DI
	LOOP	EmsSetLoop
	JMP	SHORT EmsSetActiveExit

EmsSetActiveNew:
	PUSH	DS
	MOV	AX, 4E01H
	LDS	SI, pBuffer
	INT	67H
	POP	DS

EmsSetActiveExit:
	POP	BP
	RET	4
EmsSetActiveRam ENDP

PURGE pBuffer
$EJECT

; EmsSwapTasksEmsRam: PROCEDURE (lastPid, curPid) CLEAN
;     DCL lastPid  SELECTOR
;     DCL curPid   SELECTOR
;
; This routine will save the current EMS state into the lastPid's process
; control block and restore the EMS state from the curPid's process cntl block

; emsValid-ity must be checked by the caller and DS must point to DGROUP

lastPid EQU  WORD PTR [BP+6]
curPid  EQU  WORD PTR [BP+4]

EmsSwapTasksEmsRam PROC NEAR
	PUSH	BP
	MOV	BP, SP

	MOV	DX, lastPid	; Set up values that are in common to both
	LEA	DI, DS:pcbEms	; lastPid and offset into pcb for ems state

	CMP	emsVersion, newVersFence	; If newer version of EMS driver is around
	JAE	EmsSwapTasksEmsNew	; then use the new version

EmsSwapTasksEmsOld:
	CMP	DX, goodBye	; If last process to run is exiting then
	JE	EmsSwapTasksOldRestore	; don't restore ems state into nothingness

	PUSH	DX
	PUSH	DI
	CALL	EmsSaveContext

EmsSwapTasksOldRestore:
	PUSH	curPid
	LEA	AX, DS:pcbEms
	PUSH AX
	CALL	EmsSetActiveRam
	JMP	SHORT EmsSwapTasksEmsExit

EmsSwapTasksEmsNew:
	PUSH	DS
	MOV	AX, 4E02H	; Save and Restore EMS state
	MOV  ES, DX	; last pid set at beginning of routine
	MOV  DS, curPid
	MOV  SI, DI	; offset into pcb set at beginning of rtn
	CMP	DX, goodBye	; if last pid has not exited yet then
	JNE	EmsSwapTasksEmsNewHere	; Do both save and restore function, else

	DEC	AX	; only restore EMS state (i.e. 4E01H)

EmsSwapTasksEmsNewHere:
	INT	67H
	POP	DS

EmsSwapTasksEmsExit:
	POP	BP
	RET	4
EmsSwapTasksEmsRam ENDP

PURGE lastPid, curPid
$EJECT

pid     EQU WORD PTR [BP+8]
emsSlot EQU WORD PTR [BP+6]

EmsSetProcessRam PROC NEAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	MOV	AX, DGROUP
	MOV	DS, AX

	CMP	emsValid, 0	; If ems does not exist then there is not
	JE	EmsSetProcessRamRet	; an ems context area - don't do anything

	CALL	WaitOnEmsSema

	MOV	DX, sEmptyContext	; Init source of context to the
	XOR	SI, SI	; empty context save area

	MOV	DI, emsSlot
	CMP	DI, emsBase	; If slotID is below range of ems IDs (ROM)
	JB	EmsCopyToProcessRam	; then clear the ems saved context area

	SUB	DI, emsBase	; Get the ems slotID to be zero relative
	CMP	DI, maxEmsEntries	; If the slotID is out of range of ems
	JAE	EmsCopyToProcessRam	; then clear the ems saved context area

	SHL	DI, 1	; index into array of words
	MOV	ES, sEmsList	; selector to emsList array
	MOV	AX, ES:[DI]	; get the selector to ems slot entry
	CMP	AX, NULLWORD	; if invalid then
	JE	EmsCopyToProcessRam	; clear the ems saved context area

	MOV	DX, AX	; Source of context is allocated ems entry's
	LEA	SI, DS:emsContext	; emsEntry.emsContext

EmsCopyToProcessRam:
	PUSH	DS
	MOV	CX, emsContextSize	; Size of move is size of ems context area
	MOV	DS, DX	; Source of move was set in DX
	MOV	ES, pid	; Dest of move/clear
	LEA	DI, ES:pcbEms	; is pcb.pcbEms
	CLD		; Move forward
	REP	MOVSB	; Copy emsEntry.context to pcb.emsArea
	POP	DS

	CALL	SignalEmsSema

EmsSetProcessRamRet:
	POP	BP
	POP	DS
	RET	4
EmsSetProcessRam ENDP

PURGE pid, emsSlot
$EJECT

; This routine returns a word value but most existing programs that will use
; this value will treat it as a byte so the value should be in the range of
; 0 - 255.  But really it should be in the range of 0 - 127 because of a
; special use of the high order bit by CpSetActiveSlot.  But really the
; range should be from 32 - 127 because the lower values are used by ROMs.
; For now only 32 values are being used for EMS entries.

; EmsAllocate: PROCEDURE (len, pid, uniqueID, pError) WORD CLEAN
;  DCL len       WORD;
;  DCL uniqueID  WORD;
;  DCL pid       SELECTOR;
;  DCL pError    PTR;

len		EQU  WORD PTR [BP+16]
pid		EQU  WORD PTR [BP+14]
uniqueID	EQU  WORD PTR [BP+12]
pError	EQU DWORD PTR [BP+08]

localErr EQU  WORD PTR [BP-02]
emsIndex	EQU  WORD PTR [BP-04]


EmsAllocate PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	MOV	AX, DGROUP
	MOV	DS, AX
	SUB	SP, 4	; leave room on stack for local variables

	TEST	emsValid, TRUE
	JNZ	EmsAllocEmsValid

	MOV	AX, eNotSupport	; error is eNotSupport if no ems supported
	JMP	EmsAllocError2

EmsAllocEmsValid:
	CALL	WaitOnEmsSema

	MOV	ES, sEmsList
	XOR	DI, DI
	MOV	AX, NULLWORD
	MOV	CX, maxEmsEntries
	MOV	DX, CX
	CLD
	REPNE SCASW
	JE	EmsAllocIndexFound

	MOV	AX, eOutOfMem	; error is eOutOfMem if no more room
	JMP	EmsAllocError1

EmsAllocIndexFound:
	SUB	DX, CX
	DEC	DX
	MOV	emsIndex, DX	; index of next entry in ems list

	MOV	AX, SIZE EmsEntryType - dfltCntxtSize
	ADD	AX, emsContextSize
	TEST	integridEmsAlloc, TRUE
	JNZ	EmsAllocFromMsDos
	
EmsAllocFromGRiD:
	XOR	CX, CX	; systemPid = 0
	PUSH	CX	; owner of memory is system
	PUSH	AX	; allocate space for an ems entry
	LEA	AX, localErr
	PUSH	SS
	PUSH	AX	; error is on stack
	CALL	IntAllocate	; allocate memory, ES => allocated block
	MOV	AX, localErr
	OR	AX, AX	; if no error
	JZ	EmsAllocGotMemory	; then keep going
	JMP	EmsAllocError1	; else return error

EmsAllocFromMsDos:
	ADD	AX, 15
	MOV	CL, 4
	SHR	AX, CL
	XCHG	BX, AX
	MOV	AH, 48H
	INT	21H
	MOV	ES, AX
	JNC	EmsAllocGotMemory	; then keep going
	JMP	EmsAllocError1	; else return error

EmsAllocGotMemory:
	CLD
	XOR	AX, AX
	MOV	DI, AX	; ES returned by allocate routine above
	MOV	CX, SIZE EmsEntryType - dfltCntxtSize ; Don't need to zero cntxt area
	REP	STOSB	; SETB (0, @emsEntry, SIZE(emsEntry))
	MOV	DI, AX	; Reset pointer to beginning of emsEntry

	MOV	AX, len
	STOSW	; emsEntry.emsBytes = len
	MOV	BX, AX
	MOV	CL, 14
	SHR	BX, CL	; pagesize = 16k use only high 2 bits
	AND	AX, 03FFFh	; mask off lower 14 bits
	JZ 	EmsAllocAllocEms

	INC	BX	; round up to nearest page

EmsAllocAllocEms:
	MOV	AX, BX	; store # pages count in AX for STOSW
	STOSW	; emsEntry.emsBlocks = len MOD 16k
	XCHG	CX, AX	; save the # pages count in CX (for loop)
	MOV	AH, 43h	; EmsAllocate call to EMM, DX = ems handle
	INT	67h	; call EMM
	OR	AH, AH	; is there an error?
	JNZ	EmsAllocErrorFreeMem

	CLD
	XCHG	AX, DX	; store ems handle in AX for STOSW
	STOSW	; emsEntry.emsHandle = emsHandle
	MOV	AX, pid
	STOSW	; emsEntry.pid = pid
	MOV	AX, uniqueID
	STOSW	; emsEntry.emsID = uniqueID

	PUSH	ES	; save pointer to ems entry
	PUSH	CX	; save count of number of pages

	XOR	AX, AX
	PUSH	sSavedContext
	PUSH	AX
	CALL	EmsSaveContext	; Save current state of EMS in saved context

	POP	CX	; restore count of number of pages
	POP	ES	; restore pointer to ems entry
	MOV	DX, ES:emsHandle	; restore ems handle from ems entry buffer
	MOV	BX, 0FFFFh	; prime the loop counter

EmsAllocMapPageLoop:
	INC	BX	; next logical/physical page
	MOV	AL, BL	; phys page = log page
	MOV	AH, 44h	; mapping function
	INT	67h	; map log page i to phys page i
	OR	AH, AH
	JNZ	EmsAllocErrorFreeEms
	LOOP	EMSAllocMapPageLoop	; Loop to the next logical page
	JMP	SHORT EmsAllocSaveContext

EmsAllocErrorFreeEms:
	PUSH	AX	; Save error
	MOV	AH, 45h	; Ems free page(s) call to EMM
	INT	67h	; call EMM
	POP	AX	; Restore error

EmsAllocErrorFreeMem:
	PUSH	AX	; Save error
	TEST	integridEmsAlloc, TRUE
	JZ	EmsAllocFreeGRiD

EmsAllocFreeMsDos:
	MOV	AH, 49H
	INT	21H
	JMP	SHORT EmsAllocErrorFreeMem2

EmsAllocFreeGRiD:
	PUSH	ES
	XOR	AX, AX
	PUSH	AX	; PUSH @emsEntry onto stack
	LEA	AX, localErr
	PUSH	SS
	PUSH	AX	; PUSH @error onto stack
	CALL	CpFree	; CALL free memory routine

EmsAllocErrorFreeMem2:
	POP	AX	; Restore error
	MOV	AL, 0
	XCHG	AH, AL	; Make error in AH into error in AX
	JMP	SHORT EmsAllocError1

EmsAllocSaveContext:
	PUSH	ES	; save pointer to ems entry

	LEA	AX, ES:emsContext
	PUSH	ES
	PUSH	AX
	CALL	EmsSaveContext	; Save current state of EMS in emsContext

	TEST	integridEmsAlloc, TRUE	; If allocate for InteGRiD's OS_CGROUP
	JNZ	EmsAllocSaveContextDone	; then don't restore EMS register state

	XOR	AX, AX
	PUSH	sSavedContext
	PUSH	AX
	CALL	EmsSetActiveRam	; Restore current state of EMS

EmsAllocSaveContextDone:
	POP	BX	; restore pointer to ems entry
	MOV	ES, sEmsList
	MOV	DI, emsIndex
	SHL	DI, 1
	MOV	ES:[DI], BX	; emsList (index) = sEmsEntry

	XOR	AX, AX	; No error (AX cleared above)

EmsAllocError1:
	CALL	SignalEmsSema	; Does not change AX

EmsAllocError2:
	LES	BX, pError
	MOV	ES:[BX], AX	; store the error
	OR	AX, AX
	MOV	AX, NULLWORD	; return invalid ems slot for error case
	JNZ	EmsAllocRet

	MOV	AX, emsIndex
	ADD	AX, emsBase	; return ems slot identifier for good case

EmsAllocRet:
	MOV	SP, BP
	POP	BP
	POP	DS
	RET	10
EmsAllocate ENDP

PURGE len, pid, uniqueID, pError
PURGE localErr, emsIndex
$EJECT

; IntEmsFree: PROCEDURE WORD CLEAN
;
; This routine does the actual freeing an allocated segment in EMS
; and its memory buffer and clears the entry in the ems list

; Entry
;	ES:DI => entry in ems list
;	CX = NULLWORD (0FFFFH)

; Exit
;	AX = error

error EQU WORD PTR [BP-2]

IntEmsFree PROC NEAR
	PUSH	BP
	MOV	BP, SP

	PUSH	CX	; Leave room on stack for error variable

	XCHG	ES:[DI], CX	; emsList (emsID) = NULLWORD
	MOV	ES, CX	; sEmsEntry
	MOV	BX, OFFSET emsHandle
	MOV	DX, ES:[BX]
	MOV	AH, 45h
	INT	67H	; Deallocate the ems memory

	MOV	AL, AH
	XOR	AH, AH	; Error code return

	PUSH	AX
	XOR	AX, AX
	PUSH	ES
	PUSH	AX
	LEA	AX, error
	PUSH	SS
	PUSH	AX
	CALL	CpFree
	POP	AX
	OR	AX, AX
	JNZ	IntEmsFreeRet

	MOV	AX, error

IntEmsFreeRet:
	POP	CX	; Clear stack of error code
	POP	BP
	RET
IntEmsFree ENDP

PURGE error
$EJECT

; EmsFree: PROCEDURE (theEmsID) WORD CLEAN
;     DCL emsID WORD;
;
; This routine will free an allocated segment in EMS

theEmsID EQU WORD PTR [BP+8]

EmsFree PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	MOV	AX, DGROUP
	MOV	DS, AX

	MOV	AX, eNotSupport
	TEST	emsValid, TRUE
	JZ	EmsFreeRet

	CALL	WaitOnEmsSema

	MOV	DI, theEmsID
	SUB	DI, emsBase
	SHL	DI, 1
	MOV	AX, eBadPointer
	CMP	DI, maxEmsEntries
	JAE	EmsFreeExit

	MOV	ES, sEmsList
	MOV	CX, NULLWORD
	CMP	CX, ES:[DI]
	JE	EmsFreeExit

	CALL	IntEmsFree

EmsFreeExit:
	CALL	SignalEmsSema	; Does not change AX

EmsFreeRet:
	POP	BP
	POP	DS
	RET	2
EmsFree ENDP

PURGE theEmsID
$EJECT

; EmsFreeTasksMem: PROCEDURE (procID) CLEAN
;     DCL procID WORD;
;
; This routine will free any allocated segments in EMS belonging
; to the specified process or all of them if procID = NULLWORD

procID EQU WORD PTR [BP+8]

EmsFreeTasksMem PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	MOV	AX, DGROUP
	MOV	DS, AX

	TEST	emsValid, TRUE
	JZ	EmsFreeTasksMemRet

	CALL	WaitOnEmsSema

	XOR	DI, DI

EmsFreeTasksMemLoop:
	MOV	ES, sEmsList
	MOV	DX, ES:[DI]
	MOV	CX, NULLWORD
	CMP	DX, CX
	JE	EmsFreeTasksMemNext

	MOV	SI, ES	; Save sEmsList in SI
	MOV	ES, DX
	MOV	BX, OFFSET emsPid
	MOV	AX, procID
	CMP	AX, ES:[BX]
	JE	EmsFreeTasksMemHere

	CMP	AX, CX
	JNE	EmsFreeTasksMemNext

EmsFreeTasksMemHere:
	MOV	ES, SI	; Restore sEmsList from SI
	PUSH	DI
	CALL	IntEmsFree
	POP	DI

EmsFreeTasksMemNext:
	INC	DI
	INC	DI
	CMP	DI, maxEmsBufSize	; 2 * maxEmsEntries
	JB	EmsFreeTasksMemLoop

	CMP	procID, NULLWORD	; If not freeing all of EMS (before Exit)
	JNE	EmsFreeTasksMemSignal	; then don't do this next thing

	PUSH	sEmptyContext
	XOR	AX, AX
	PUSH	AX
	CALL	EmsSetActiveRam	; Reset state of EMS to before InteGRiD ran

EmsFreeTasksMemSignal:
	CALL	SignalEmsSema

EmsFreeTasksMemRet:
	POP	BP
	POP	DS
	RET	2
EmsFreeTasksMem ENDP

PURGE procID
$EJECT


; EmsGetMemStatus: PROCEDURE (procID, pEmsStatus, pError) CLEAN
;
; This routine return information about the process specified
; giving memory allocated to that process (or all processes)
; and the amount of free and total ems memory available.

allocOffset EQU 12

procID      EQU  WORD PTR [BP+16]
pEmsStatus  EQU DWORD PTR [BP+12]
pError      EQU DWORD PTR [BP+08]

EmsGetMemStatus PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	MOV	AX, DGROUP
	MOV	DS, AX

	CLD
	XOR	AX, AX
	MOV	CX, 9	; There are 18 bytes (9 words) in emsStatus
	LES	DI, pEmsStatus

EmsGetMemInitLoop:
	STOSW	; Preset emsStatus info to all zeros
	LOOP	EmsGetMemInitLoop

	MOV	AX, eNotSupport
	TEST	emsValid, TRUE
	JZ	EmsGetMemRet

	CALL	WaitOnEmsSema

	MOV	AH, 42h	; Get unallocated page count
	INT	67h	; Returns DX = total blks; BX = free blks
	XCHG	AH, AL
	AND	AX, 0FFH	; Get error into AX (and check for non-zero)
	JNZ	EmsGetMemExit

	CLD
	LES	DI, pEmsStatus	; Get pointer to ems status
	MOV	CX, 4000H	; Number of bytes in a ems page / block

	XCHG	DX, AX
	STOSW	; Total pages of EMS memory

	MUL	CX
	STOSW
	XCHG	DX, AX
	STOSW	; Total bytes of EMS memory

	XCHG	BX, AX
	STOSW	; Free pages of EMS memory

	MUL	CX
	STOSW
	XCHG	DX, AX
	STOSW	; Free bytes of EMS memory

	XOR	BX, BX	; init blkCount = 0
	MOV	CX, BX	; init byteCount (high) = 0
	MOV	DX, BX	; init byteCount (low) = 0
	MOV	DI, BX	; init index of emsList = 0
	MOV	SI, sEmsList	; save sEmsList in SI
	MOV	AX, procID

EmsGetMemLoop:
	MOV	ES, SI
	CMP	ES:[DI], NULLWORD
	JE	EmsGetMemNext

	MOV	ES, ES:[DI]
	CMP	AX, ES:emsPid
	JE	EmsGetMemAddIt

	CMP	AX, NULLWORD	; incrementing NULLWORD will set zero flag
	JNE	EmsGetMemNext

EmsGetMemAddIt:
	ADD	BX, ES:emsBlocks
	ADD	DX, ES:emsBytes
	ADC	CX, 0

EmsGetMemNext:
	INC	DI
	INC	DI
	CMP	DI, maxEmsBufSize	; 2 * maxEmsEntries
	JB	EmsGetMemLoop

	LES	DI, pEmsStatus	; Get pointer to ems status
	ADD	DI, allocOffset

	XCHG	AX, BX
	STOSW	; Allocated pages of EMS (of procID / all)
	XCHG	AX, DX
	STOSW
	XCHG	AX, CX
	STOSW	; Allocated bytes of EMS (of procID / all)

	XOR	AX, AX	; Error = eOK

EmsGetMemExit:
	CALL	SignalEmsSema	; AX is saved by SignalEmsSema

EmsGetMemRet:
	LES	BX, pError
	MOV	ES:[BX], AX

	POP	BP
	POP	DS
	RET	10
EmsGetMemStatus ENDP

PURGE procID, pEmsStatus, pError
$EJECT

; CpGetMySlot: PROCEDURE (slotID) CLEAN
;     DCL slotID WORD;
;
; This routine will return an ems/rom slot that corresponds to
; the given slotID passed in.

slotID EQU WORD PTR [BP+8]

CpGetMySlot PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	MOV	AX, DGROUP
	MOV	DS, AX

	TEST	emsValid, TRUE
	JZ	CpGetMySlotMaybeRoms

	CALL	WaitOnEmsSema

	MOV	AX, slotID
	XOR	DI, DI
	MOV	SI, sEmsList

CpGetMySlotLoop:
	MOV	ES, SI
	MOV	DX, ES:[DI]
	CMP	DX, NULLWORD
	JE	CpGetMySlotNext

	MOV	ES, DX
	MOV	BX, OFFSET emsID
	CMP	AX, ES:[BX]
	JNE	CpGetMySlotNext

	XCHG	AX, DI
	SHR	AX, 1
	ADD	AL, emsBase
	CALL	SignalEmsSema	; Does not change AX
	JMP	SHORT CpGetMySlotRet

CpGetMySlotNext:
	INC	DI
	INC	DI
	CMP	DI, maxEmsBufSize	; 2 * maxEmsEntries
	JB	CpGetMySlotLoop

	CALL	SignalEmsSema	; Does not change AX

CpGetMySlotMaybeRoms:
	MOV	AL, NULLBYTE
	TEST romsExecute, TRUE
	JZ	CpGetMySlotRet

	PUSH	slotID
	CALL	CpGetMyRomSlot

CpGetMySlotRet:
	POP	BP
	POP	DS
	RET	2
CpGetMySlot ENDP

PURGE slotID
$EJECT

; CpSetActiveEmsSlot: PROCEDURE (slot) BYTE CLEAN;
;     DCL slot BYTE;
;
; It is also assumed that the NULLBYTE case has been handled.

newSlot EQU BYTE PTR [BP+4]

CpSetActiveEmsSlot PROC NEAR
	PUSH	BP
	MOV	BP, SP

	MOV	DL, newSlot	; DL = new slot to be set
	CMP	DL, invalidSlot	; If setting new slot to unused slot
	JE	CpSetSlotAndDisableRoms	; then set it and disable roms

	MOV	AL, NULLBYTE	; nullbyte indicates error

	CMP	emsValid, 0	; if ems does not exist
	JE	CpSetActiveEmsRet	; return error if no ems

	MOV	BL, DL	; Save original value in BL for later
	AND	DL, 7FH	; Mask off disable bit while checking
	SUB	DL, emsBase	; If below first ems value
	JC	CpSetActiveEmsRet	; then return error

	CMP	DL, maxEmsEntries	; or if above last valid ems index
	JAE	CpSetActiveEmsRet	; then return error

	TEST	BL, 80H	; See if disable bit is on (IS THIS USED ?)
	JNZ	CpSetSlotAndDisableRoms	; if so then just set it and disable roms

	XOR	DH, DH
	PUSH	DX
	CALL	WaitOnEmsSema
	POP	DI

	SHL	DI, 1	; index into array of words
	MOV	ES, sEmsList	; selector to emsList array
	MOV	AX, ES:[DI]	; get the selector to ems slot entry
	CMP	AX, NULLWORD	; if selector is valid then
	JNE	CpSetActiveEmsHere	; swap these EMS banks in

	CALL	SignalEmsSema	; Does not change AX
	JMP	SHORT CpSetActiveEmsRet	; Return slot = NULLBYTE

CpSetActiveEmsHere:
	XCHG	BX, AX	; Save BASE to emsEntry.emsContext in BX

; A short note:  This grossness about masking off all interrupts
; stems from the fact that the EMS drivers enable interrupts when
; software many, many levels above this assume that they will stay off.
; Masking off interrupts is the only way to do this short of rewriting
; all of InteGRiD !!!

	IN   AL, intMaskReg	; Get state of interrupt mask
	PUSH AX	; and save it
	MOV  AL, maskOffAllInts	; Then mask off all interrupts
	OUT  intMaskReg, AL

	PUSH	BX	; BASE to emsEntry.emsContext
	LEA	AX, DS:emsContext	; OFFSET to emsEntry.emsContext
	PUSH	AX
	CALL	EmsSetActiveRam

	POP  AX
	OUT  intMaskReg, AL	; Restore state of interrupt mask

	CALL	SignalEmsSema

CpSetSlotAndDisableRoms:
	MOV	AL, curSlot	; save current slot
	PUSH	AX
	MOV	AL, newSlot	; AL = slot
	CALL	IntCpSetActiveRomSlot
	POP	AX

CpSetActiveEmsRet:
	POP	BP
    RET	2
CpSetActiveEmsSlot ENDP

PURGE newSlot
$EJECT

; EmsStartAddress: PROCEDURE SELECTOR CLEAN
;
; This routine will return a selector to the start of EMS in the mem map.

EmsStartAddress PROC FAR
  PUSH DS
  MOV  AX, DGROUP
  MOV  DS, AX
  MOV  AX, startAddress
  POP  DS
  RET
EmsStartAddress ENDP
$EJECT

;  InitEMS: PROCEDURE CLEAN;
;
; This routine will initialize the variables needed for the EMS stuff.


emsDriverName DB 'EMMXXXX0'

InitEMS PROC FAR
	PUSH	DS
	PUSH	BP

	CLD		; Used for REPE & SETW below

	PUSH	CS
	POP	DS
	MOV	AX, 3567H	; Get address for interrupt 67 in ES:BX
	INT	21H
	MOV	DI, 0AH	; Offset of driver name
	LEA	SI, emsDriverName	; Offset of known EMM driver name
	CLD
	MOV	CX, 8
	REPE	CMPSB
	MOV	AX, DGROUP
	MOV	DS, AX
	JNE	InitErrorHop

; Init the EMS semaphore variable to "uninitialized"

	MOV	emsListSema, 0	; emsListSema not valid yet

; First get the version number

	MOV	AH, 46h
	INT	67h
	OR	AH, AH
	JNZ	InitErrorHop

	MOV	emsVersion, AL
	CMP	AL, newVersFence
	JAE	InitEmsAtLeastVersion32

; First get the io port addresses and the number of boards

InitEmsPreVersion32:
	MOV	AX, DS	; AX set to DGROUP above
	MOV	ES, AX	; address of place to write
	MOV	DI, OFFSET DGROUP:IOPorts
	MOV	AH, 49h
	INT	67h	; CALL the memory manager
	MOV	numBoards, AL	; store the number of boards
	OR	AH, AH
	JNZ	InitErrorHop

	SHL	AL, 1
	SHL	AL, 1	; Size of context = 4 * number of boards
	JMP	SHORT InitEmsAllocateContext

InitEmsAtLeastVersion32:
	MOV	AX, 4E03h
	INT	67h
	OR	AH, AH
	JNZ	InitErrorHop

InitEmsAllocateContext:
	MOV	emsContextSize, AX	; Needed for allocating Pcbs with ems stuff

	ADD	AX, 15	; Round up so division gives # 16 byte blks
	MOV	CL, 4
	SHR	AX, CL
	XCHG	BX, AX
	PUSH	BX	; Save size (in blocks) of context area
	MOV	AH, 48H	; Allocate block for MsDos
	INT	21H	; Call MsDos
	MOV	sSavedContext, AX
	POP	BX	; Restore size (in blocks) of context area
	JNC	InitEmsEmptyContext

InitErrorHop:
	JMP	SHORT InitError

; Next allocate area to store the "empty" context

InitEmsEmptyContext:
	MOV	AH, 48H	; Allocate block from MsDos (BX set above)
	INT	21H	; Call MsDos
	MOV	sEmptyContext, AX
	JC	InitError

; Initialize the "empty" context area based on version of EMS being used

	CMP	emsVersion, newVersFence
	JAE	InitEmsEmpty32

InitEmsEmptyPre32:
	MOV	ES, AX
	XOR	DI, DI	; Destination of STOSB is @emptyContext
	MOV	CX, emsContextSize	; Length of STOSB is SIZE (emptyContext)
	XOR	AX, AX	; Storing all zeros
	CLD		; Forward
	REP	STOSB
	JMP	SHORT InitEmsGetStartAddress

InitEmsEmpty32:
	CMP	emsVersion, vers40Fence	; If version 3.2 then take current state
	JB	InitEmsSaveEmptyState	; as the empty state (since no unmapping)

	MOV	BX, 0FFFFH	; Unmap the page at physical page in AL
	MOV	CX, 4	; Unmap all four pages of the 64K area used
	XOR	DX, DX	; EMS handle can be used to unmap pages

InitEmsEmpty40Loop:
	MOV	AH, 44h	; mapping/unmapping function
	MOV	AL, CL	; unmap this page
	DEC	AX
	INT	67h	; unmap phys page i
	OR	AH, AH
	JNZ	InitError
	LOOP	InitEmsEmpty40Loop

InitEmsSaveEmptyState:
	PUSH	sEmptyContext
	XOR	AX, AX
	PUSH	AX
	CALL	EmsSaveContext	; Save state of all pages unmapped

; Next get the start address of the EMS area

InitEmsGetStartAddress:
	MOV	AH, 41H
	INT	67h	; starting address of page frame
	MOV	startAddress, BX
	OR	AH, AH
	JNZ	InitError

; Use MsDos allocate because this rtn is called before GRiD allocate exists

	MOV	BX, maxEmsBufBlks
	MOV	AH, 48H
	INT	21H
	MOV	sEmsList, AX
	JC	InitError

	CLD
	MOV	ES, AX
	XOR	DI, DI
	MOV	CX, maxEmsEntries
	MOV	AX, 0FFFFH
	REP	STOSW

	MOV	AL, TRUE	; emsValid = TRUE;
	JMP	SHORT InitExit

InitError:
	XOR	AX, AX	; emsValid = FALSE;
	MOV	startAddress, AX
	MOV	emsContextSize, AX	; needed for allocating Pcbs without ems stuff

InitExit:
	MOV	emsValid, AL
	MOV	integridEmsAlloc, FALSE	; Let this be set in LoadOsCGroupIntoEms
	POP	BP
	POP	DS
	RET
InitEMS ENDP


CODE ENDS

    END
